// This is the main DLL file.

#using "CSharp.dll"

#include "stdafx.h"
#include "CppWrapper.h"
#include <msclr\auto_gcroot.h>

using namespace System::Runtime::InteropServices; // Marshal

class CppWrapperPrivate
{
public: msclr::auto_gcroot<CSharp^> csharp;
};

CppWrapper::CppWrapper()
{
	_private = new CppWrapperPrivate();
	_private->csharp = gcnew CSharp();
}

// version makes simple call to C#. C# returns a real(double) variable
double CppWrapper::First()
{
	// run C# routine
	return _private->csharp->First();
}

// version transfers a text variable to C#. C# returns a real(double) variable
double CppWrapper::Second(const char* txt)
{
	// run C# routine
	return _private->csharp->Second(gcnew System::String(txt));
}

// version transfers a text variable and a real(double) variable to C#. C# returns a real(double) variable evaluated from the input real(double) variable
double CppWrapper::Fifth(const char* txt, double* zz2)
{
	// copy unmanaged arrays to managed arrays
	array<double>^ _zz2 = gcnew array<double>(1);
	Marshal::Copy(System::IntPtr((void *)zz2), _zz2, 0, 1);

	// run C# routine
	return _private->csharp->Fifth(gcnew System::String(txt), _zz2);
}

// version transfers a text variable, a int vector, and a real(double) vector to C#. C# returns a real(double) vector evaluated using the input data
void CppWrapper::Sixth(const char* txt, long* int_vec, double* xx)
{
	// copy unmanaged arrays to managed arrays
	int temp = int_vec[0] * int_vec[1];
	array<__int32>^ _int_vec = gcnew array<__int32>(4);
	array<double>^ _xx = gcnew array<double>(temp);
	Marshal::Copy(System::IntPtr((void *)int_vec), _int_vec, 0, 4);
	Marshal::Copy(System::IntPtr((void *)xx), _xx, 0, temp);

	// run C# routine
	_private->csharp->Sixth(gcnew System::String(txt), _int_vec, _xx);

	// copy managed arrays to unmanaged arrays
	Marshal::Copy(_xx, 0, System::IntPtr((void *)xx), temp);

	// exit wrapper
	return;
}

CppWrapper::~CppWrapper()
{
	delete _private;
}

/*

For details about copying data between managed and unmanaged code, see:
https://msdn.microsoft.com/en-us/library/system.runtime.interopservices.marshal_methods(v=vs.110).aspx

Structure of approach based on: http://pragmateek.com/using-c-from-native-c-with-the-help-of-ccli-v2/
System::String is not meant to be CLI compliant, and this may result in errors in the future.

*/
